# theme-switchers

Please send patches or remarks to
[jayvii+theme-switchers[AT]posteo[DOT]de](jayvii+theme-switchers[AT]posteo[DOT]de)

Tools to switch between dark and light mode of some tools I use.

## Switch themes

You can switch all themes at once with the `switch-themes.sh` script. When
called without arguments, switches from the current to the other. Can be called
with either `dark` or `light` to choose a specific:

```bash
./switch-themes.sh "dark"
```

The `auto-themes.sh` script switches your themes by daytime. It requires the start and end time of the **light** theme as argument and will set the dark theme in all other cases. Call it for example via cron (e.g. every 5 minutes):

```cron
*/5 * * * * $HOME/.local/share/theme-switchers/auto-themes.sh "09:00" "23:00"
```

### GNOME
Regarding the [GNOME Desktop](https://www.gnome.org/):
Uses `gsettings` to switch between dark and light mode.

When called without arguments, switches from the current to the other. Can be
called with either `dark` or `light` to choose a specific:

```bash
./gnome-switch-theme.sh "dark"
```

### Helix

Regarding the [Helix editor](https://helix-editor.com/):
Overrides the `theme` variable within the `config.toml` file.

When called without arguments, switches from the current to the other. Can be
called with either `dark` or `light` to choose a specific:

```bash
./helix-switch-theme.sh "dark"
```

Requires a dark and light theme to be defined in
`~/.config/helix/autothemes.toml`:
```toml
theme_dark = "onedark"
theme_light = "onelight"
```

