#!/usr/bin/env bash

# exit on error
set -eo pipefail

# check whether input was given
if [ -z $1 ]; then
  # get current GTK theme
  target=$(gsettings get org.gnome.desktop.interface color-scheme)
else
  target="$1"
fi

export XDG_RUNTIME_DIR="/run/user/$(id -u)"
export DBUS_SESSION_BUS_ADDRESS="unix:path=${XDG_RUNTIME_DIR}/bus"

# If we want a dark theme, but the current theme is not, switch theme to dark
if [[ "$target" == "'prefer-light'" ]] || [[ "$target" == "dark" ]]; then
  gsettings set org.gnome.desktop.interface color-scheme "prefer-dark"
  echo "[✓] Switched gnome to dark!"

# If we want a light theme, but the current theme is not, switch theme to light
elif [[ "$target" == "'prefer-dark'" ]] || [[ "$target" == "light" ]]; then
  gsettings set org.gnome.desktop.interface color-scheme "prefer-light"
  echo "[✓] Switched gnome to light!"

else
  echo "[-] Did not switch theme: $sys_theme"

fi
