# Zeitung

For comments and ideas, please send issues and code-patches to:
[jayvii+zeitung[AT]posteo[DOT]de](mailto:jayvii+zeitung[AT]posteo[DOT]de).

## About

A thin script around [`perlanet`](https://github.com/davorg-cpan/perlanet) and
[`morss`](github.com/pictuga/morss) that gathers news from a pre-defined set of
sources and formats them for newspaper-style consumption in various formats,
such as:

- HTML, i.e. for any type of browser either mobile or desktop
- PDF, once in DIN A4 and once in DIN A 5 format with the
  [Eisvogel](https://github.com/Wandmalfarbe/pandoc-latex-template) template
- EPUB for ebook readers

Zeitung is intended to run **once a day**, e.g. in the very early morning, so
you can get updated on the latest news once a day without falling in a habit to
check news constantly all day. Of course, the script also works if you would
like to update all document types multiple times a day, if you really wish to.

For example, you could generate the documents automatically every morning at 6AM
on your webserver and publish them through your already running webserver, from
where you can download the appropriate document to your device.

- Examplary use cases would be to read *Zeitung* in the morning on an E-Book
  reader (EPUB) or tablet (EPUB or DIN A5 PDF).
- Or read *Zeitung* while commuting via train on a phone (HTML or DIN A5 PDF)
- Or maybe, for you the best time for news consumption is during the evening on
  your computer screen (HTML or DIN A4 PDF)

Please be aware that the `generate.sh` script will strip out all articles that
were published before yesterday. Again, this is intended to be read daily, once
a day and be done with it.

General formatting, external content, graphics and advertisement is stripped
from the article view as much as possible.

## Name

*Zeitung* means newspaper in German. Very original, I know.

![Meme: A cat in a suit, sitting at a breakfast table and reading newspaper. The caption sais in German: "I should read Zeitung"](https://paste.jayvii.de/21fe93f74b482a58e395849dde7b14e3848e4d70e2cd8a4294f38d848cbb2ff3)

## Screenshots

Here are some screenshot for outputs *Zeitung* can look like. The look is
subject to change and can be adapted freely. But the screenshots below will give
an impression of what *Zeitung* achieves and how it presents articles.

![HTML-Version of Zeitung's article overview, both as bright mode (sepia) and in dark mode (dark grey)](https://paste.jayvii.de/a22cd52890c4608e98b9c9b6acc70eb9e9aa9dcbebd722bd32b26f784d42bbde)

![HTML-Version of Zeitung's article view, both as bright mode (sepia) and in dark mode (dark grey)](https://paste.jayvii.de/ea6cd0539b05c3e324f7ce3e28e93d274d87162e887aee1b631ec740b6292c6b)

![PDF-Version of Zeitung in DIN A4 format, showing three pages: Title page, Overview and one article](https://paste.jayvii.de/74dfe8a0142a8cac50ea128a3deea099cb903a22854d17fc8fef523c14b517c1)

![EPUB-Version of Zeitung in dark mode, showing two pages: Overview and one article](https://paste.jayvii.de/0f6518e6921559ff5c36d09b7da09bf77949827548770cb90ed91635cc2fd215)

## Dependencies

- [Pandoc](https://pandoc.org/)
- [LaTeX / TeX Live](https://www.tug.org/texlive/)
  - [XeTeX](https://www.tug.org/xetex/)
  - [Source Code Pro font](https://tug.org/FontCatalogue/sourcecodepro/)
- [Perlanet](https://github.com/davorg-cpan/perlanet/)

Optionally, install [morss](https://github.com/pictuga/morss) on your own server
or use a public service like the upstream [morss.it](https://morss.it).

## How to start

Copy the example perlanet config `perlanetrc.example.yaml` to `perlanetrc.yaml`
and edit it accordingly. Please refer to the
[perlanet documentation](https://github.com/davorg-cpan/perlanet) for specifics.

For Zeitung to work properly, each feed needs both an article summary as well as
the full content of the article. Most news websites do not publish the full text
article within their RSS feeds. In these cases, you can use `morss` to fetch
the full text from the article sites for you (see `perlanetrc.example.yaml`).

Then, run the `generate.sh` script. The output documents will be stored in the
`output/` directory.
